﻿(function ($) {
    "use strict";
    var dTable = null;
    var _id = null;

    $(document).ready(function () {

        //load datatable
        Manager.GetDataList(0);
        Manager.LoadCustomerDropDown();
        Manager.LoadEmployeeDropDown();
        
        //generate datatabe serial no
        dTableManager.dTableSerialNumber(dTable);

        $("#btnFilter").on("click",function () {
            Manager.GetDataList(1);
        });

        $("#serviceId").on("keyup",function (e) {
            if (e.keyCode == 13) {
                Manager.GetDataList(1);
            }
        });

        //save change status
        JsManager.JqBootstrapValidation('#inputForm', (form, event) => {
            event.preventDefault();
            Manager.ChangeServiceStatus(form);

        });
    });

    //show edit info modal
    $(document).on('click', '.dt-button-action', function () {
        Manager.ResetForm();
        var rowData = dTable.row($(this).parent()).data();
        _id = rowData.id;
        $('#id').val(rowData.id);
        $('#span-booking-no').text(rowData.id);
        $('#status').val(rowData.status);

        $("#frmModal").modal('show');
    });


    var Manager = {
        ResetForm: function () {
            $("#inputForm").trigger('reset');
        },
        ServiceStatus: function (status) {
            var serviceStatus = ['Pending', 'Processing', 'Approved', 'Cancel', 'Done'];
            return serviceStatus[status];
        },
        ServiceFontColorClass: function (status) {
            var serviceColor = ['fc_pending', 'fc_processing', 'fc_approved', 'fc_cancel', 'fc_done'];
            return serviceColor[status];
        },
        ChangeServiceStatus: function (form) {
            if (Message.Prompt()) {
                JsManager.StartProcessBar();
                var jsonParam = form.serialize();
                var serviceUrl = "change-service-booking-status";
                JsManager.SendJson("POST", serviceUrl, jsonParam, onSuccess, onFailed);

                function onSuccess(jsonData) {
                    if (jsonData.status == "1") {
                        Message.Success("Successfully update service status to " + Manager.ServiceStatus($("#status").val()));
                        Manager.ResetForm();
                        $("#frmModal").modal('hide');
                        Manager.GetDataList(1); //reload datatable
                    } else {
                        Message.Error("Failed to update service status for " + Manager.ServiceStatus($("#status").val()));
                    }
                    JsManager.EndProcessBar();
                }
                function onFailed(xhr, status, err) {
                    JsManager.EndProcessBar();
                    Manager.ResetForm();
                    Message.Exception(xhr);
                }
            }
        },
        GetDataList: function (refresh) {
            JsManager.StartProcessBar();
            var jsonParam = {
                dateFrom: $("#dateFrom").val(),
                dateTo: $("#dateTo").val(),
                employeeId: $("#employeeId").val(),
                customerId: $("#customerId").val(),
                serviceStatus: $("#serviceStatus").val(),
                course_name: $("#ScheduleCourse_name").val(),
                bookingId: $("#serviceId").val()
            };
            var serviceUrl = "get-service-booking-info";
            JsManager.SendJsonAsyncON('GET', serviceUrl, jsonParam, onSuccess, onFailed);

            function onSuccess(jsonData) {
                Manager.LoadDataTable(jsonData.data, refresh);
                JsManager.EndProcessBar();
            }

            function onFailed(xhr, status, err) {
                JsManager.EndProcessBar();
                Message.Exception(xhr);
            }
        },
        LoadDataTable: function (data, refresh) {
            if (refresh == "0") {
                dTable = $('#tableElement').DataTable({
                    dom: "<'row'<'col-md-12'tr>>" + "<'row'<'col-md-4'i><'col-md-3 mt-2'l><'col-md-5 mt-7'p>>",
                    initComplete: function () {
                        dTableManager.Border(this, 450);
                    },
                    buttons: [],

                    scrollY: "450px",
                    scrollX: true,
                    scrollCollapse: true,
                    lengthMenu: [[50, 100, 500, -1], [50, 100, 500, "All"]],
                    columnDefs: [
                        { visible: false, targets: [] },
                        { "className": "dt-center", "targets": [3] }
                    ],
                    columns: [
                        {
                            data: null,
                            name: '',
                            'orderable': false,
                            'searchable': false,
                            title: '#SL',
                            width: 8,
                            render: function () {
                                return '';
                            }
                        },
                        {
                            data: 'id',
                            name: 'id',
                            title: 'No#'
                        },
                        {
                            data: 'date',
                            name: 'date',
                            title: 'التاريخ',
                            render: function (data, type, row) {
                                return moment(data).format('DD/MM/YYYY');
                            }
                        },
                        {
                            data: 'service',
                            name: 'service',
                            title: 'تفاصيل',
                            render: function (data, type, row) {
                                return '<div class="flex-1 ml-3 pt-1">' +
                                    '<h6 class="text-uppercase fw-bold mb-1" style="direction:rtl;text-align:right;">' +
                                    row['service'] +
                                    ' &nbsp; <span class="' + Manager.ServiceFontColorClass(row['status']) + ' pl-3" style="direction:rtl;text-align:right;">' + Manager.ServiceStatus(row['status']) + '</span>' +
                                    '</h6>' +
                                    '<span class="text-muted" style="direction:rtl;text-align:right;">' +
                                    row['customer'] + " | " + row['customer_phone_no'] + " <span class='text-primary' style='direction:rtl;text-align:right;'><br />(" + moment(row['date'] + ' ' + row['start_time']).format('LT') + " to " + moment(row['date'] + ' ' + row['end_time']).format('LT') + ")</span><br/><span style='direction:rtl;text-align:center;color:#0A197B;font-weight:800'>" + (row['course_id'] == null ? "No courses found!" : row['course_id'] + " |</span><span style='text-align:center;color:green;font-weight:600;'> " + row['stu_total'] + " | </span><span style='color:#800000;font-weight:bold;'>" + row['invigilator'] )
                                    + '</span></span>' +
                                    '</div>';
                            }
                        },
                        {
                            data: 'service',
                            name: 'service',
                            title: 'الشعب',
                            render: function (data, type, row) {
                            return '<span style="text-align:center;color:#0A197B;font-weight:800;">' + row['section'] + '</span>' ;
                          }
                        },
                        {
                            data: 'service',
                            name: 'service',
                            title: 'المساق',
                            render: function (data, type, row) {
                            return '<span style="text-align:center;color:#CC0000;font-weight:800;">' + row['dept'] + '</span><br /><span style="text-align:center;color:#0A197B;font-weight:800;">' + row['course_name'] + '</span><br /><span style="text-align:center;color:#0F6712;font-weight:bold;">' + row['lecturer'] + '</span>' ;
                           
                            }
                        },
                        {
                            name: 'Option',
                            title: 'Option',
                            width: 70,
                            render: function (data, type, row) {
                                return '<button class="btn btn-sm btn-primary dt-button-action"><i class="fas fa-location-arrow"></i> تحرير</button>';
                            }
                        },
                    ],
                    fixedColumns: false,
                    data: data
                });
            } else {
                dTable.clear().rows.add(data).draw();
            }
        },
        LoadEmployeeDropDown: function () {
            var jsonParam = { branchId: 0 };
            var serviceUrl = "get-employee-dropdown";
            JsManager.SendJson('GET', serviceUrl, jsonParam, onSuccess, onFailed);

            function onSuccess(jsonData) {
                if (jsonData.data.length < 2) {
                    JsManager.PopulateComboSelectPicker("#employeeId", jsonData.data);
                } else {
                    JsManager.PopulateComboSelectPicker("#employeeId", jsonData.data, 'All Employee');
                }
                $("#employeeId").selectpicker('refresh');
            }

            function onFailed(xhr, status, err) {
                Message.Exception(xhr);
            }
        },
        LoadCustomerDropDown: function () {
            var jsonParam = '';
            var serviceUrl = "get-customer-dropdown";
            JsManager.SendJson('GET', serviceUrl, jsonParam, onSuccess, onFailed);

            function onSuccess(jsonData) {
                JsManager.PopulateComboSelectPicker("#customerId", jsonData.data, 'All Customer');
                $("#customerId").selectpicker('refresh');
            }
            function onFailed(xhr, status, err) {
                Message.Exception(xhr);
            }
        },
    };
})(jQuery);
