<!-- begin #content -->
<div id="content" class="content">
    <div class="row">
        <div class="col-md-6">
            <h1 class="page-header"><?php echo $this->lang->line('alumni'); ?> <small><?php echo $this->lang->line('alumni_page'); ?></small></h1>
        </div>
    </div>

    <!-- begin row -->
    <div class="row">
        <!-- begin col-12 -->
        <div class="col-md-12">
            <!-- begin panel -->
            <div class="panel panel-inverse">
                <?php if ($this->session->flashdata('success')) : ?>
                    <div class="alert alert-success fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        <?php echo $this->session->flashdata('success'); ?>
                    </div>
                <?php endif; ?>
                <?php if ($this->session->flashdata('warning')) : ?>
                    <div class="alert alert-warning fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        <?php echo $this->session->flashdata('warning'); ?>
                    </div>
                <?php endif; ?>
                <div class="panel-body">
                    <table id="data-table-buttons" class="table table-striped table-bordered" style="direction:rtl;text-align:center;">
                        <thead>
                            <tr>
                                <th width="1%">#</th>
                                <th class="text-nowrap"><?php echo $this->lang->line('name'); ?></th>
                                <th class="text-nowrap"><?php echo $this->lang->line('batch'); ?></th>
                                <th class="text-nowrap"><?php echo $this->lang->line('profession'); ?></th>
                                <th class="text-nowrap"><?php echo $this->lang->line('level'); ?></th>
                                <th class="text-nowrap"><?php echo $this->lang->line('fac'); ?></th>
                                <th class="text-nowrap"><?php echo $this->lang->line('dept'); ?></th>
                                <th class="text-nowrap"><?php echo $this->lang->line('email'); ?></th>
                                <th class="text-nowrap"><?php echo $this->lang->line('mobile'); ?></th>
                                <th class="text-nowrap"><?php echo $this->lang->line('status'); ?></th>
                                <th class="text-nowrap"><?php echo $this->lang->line('blood_group'); ?></th>
                                <th class="text-nowrap"><?php echo $this->lang->line('added_on'); ?></th>
                                <th class="text-nowrap"><?php echo $this->lang->line('options'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $count = 1;
                            $this->db->order_by('timestamp', 'desc');
                            $alumni_info = $this->security->xss_clean($this->db->get('alumnus')->result_array());
                            foreach ($alumni_info as $row) :
                            ?>
                                <tr>
                                    <td><?php echo $count++; ?></td>
                                    <td style="color:#990000;font-size:0.9em;font-weight:bold;"><?php echo $row['name']; ?></td>
                                    <td><?php echo $row['batch']; ?></td>
                                    <td><?php if ($row['profession_id']) echo $this->db->get_where('profession', array('profession_id' => $row['profession_id']))->row()->name; ?></td>
                                    <td style="color:#000044;font-size:0.9em;font-weight:bold;"><?php if ($row['country_name']) echo $this->db->get_where('level', array('id' => $row['country_name']))->row()->name; ?></td>
                                    <td style="color:#331100;font-size:0.9em;font-weight:bold;"><?php if ($row['state_name']) echo $this->db->get_where('fac', array('id' => $row['state_name']))->row()->name; ?></td>
                                    <td style="color:#007700;font-size:0.9em;font-weight:bold;"><?php if ($row['city_name']) echo $this->db->get_where('dept', array('id' => $row['city_name']))->row()->name; ?></td>
                                    
                                    <td><?php echo $row['email']; ?></td>
                                    <td><?php echo $row['mobile_number']; ?></td>
                                    <td>
                                        <?php if ($row['status'] == 0) : ?>
                                            <span class="badge badge-warning"><?php echo $this->lang->line('pending'); ?></span>
                                        <?php elseif ($row['status'] == 1) : ?>
                                            <span class="badge badge-success"><?php echo $this->lang->line('active'); ?></span>
                                        <?php elseif ($row['status'] == 2) : ?>
                                            <span class="badge badge-inverse"><?php echo $this->lang->line('cancelled'); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                    <?php if ($row['blood_group'] == 'ذكر') : ?>
                                            <span style="color:#000066;font-size:0.9em;font-weight:bold;">ذكر</span>
                                    <?php else :?>
                                     <span style="color:#990000;font-size:0.9em;font-weight:bold;">أنثى</span>
                                      <?php endif; ?>
                                      </td>
                                    
                                    <td><?php echo date('d/m/Y', $row['timestamp']); ?></td>
                                   
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-white btn-xs">Action</button>
                                            <button type="button" class="btn btn-white btn-xs dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <span class="sr-only">Toggle Dropdown</span>
                                            </button>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <a class="dropdown-item" href="javascript:;" onclick="showAjaxModal('<?php echo base_url(); ?>modal/bopup/modal_show_alumnus/<?php echo $row['alumnus_id']; ?>');">
                                                    <?php echo $this->lang->line('details'); ?>
                                                </a>
                                                <a class="dropdown-item" href="javascript:;" onclick="showAjaxModal('<?php echo base_url(); ?>modal/bopup/modal_edit_alumnus/<?php echo $row['alumnus_id']; ?>');">
                                                    <?php echo $this->lang->line('edit'); ?>
                                                </a>
                                                <a class="dropdown-item" href="javascript:;" onclick="showAjaxModal('<?php echo base_url(); ?>modal/bopup/modal_change_alumnus_image/<?php echo $row['alumnus_id']; ?>');">
                                                    <?php echo $this->lang->line('change_image'); ?>
                                                </a>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" href="javascript:;" onclick="confirm_modal('<?php echo base_url(); ?>admin/alumni/delete/<?php echo $row['alumnus_id']; ?>');">
                                                    <?php echo $this->lang->line('remove'); ?>
                                                </a>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <!-- end panel -->
        </div>
        <!-- end col-12 -->
    </div>
    <!-- end row -->
</div>
<!-- end #content -->
